/* 	OracleCondition.java
 *		Copyright (c) 2001, Dennis Groenendijk
 * 				      2002-2007 Brains2B.org
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that
 * the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions and 
 * the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
 * the following disclaimer in the documentation and/or other materials provided with the distribution. 
 * 3. The name of the author may not be used to endorse or promote products derived from this software 
 * without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/* @#History
 * [When]		[Who]				[What]
 * Nov 25, 2002	dennis@brains2b.nl	Added possibilty to add a query with
 * 									parameters to the Condition
 * 11-12-2002		dennis@brains2b.nl	Added getPreparedQuery(), 
 * 									fixed orderby depenedency on Condition
 * 16-02-2003		dennis@brains2b.nl	Make it possible to set a condition to null and have
 * 									it processed as is NULL through the database.
 * 06-03-2003		dennis@brains2b.nl 	If condition is added by a % condition is created with like.
 * 									Changed DEBUG into using the default Logger				
 * 02-06-2003		dennis@brains2b.nl	control addParameter for Date values
 * 14-12-2003		dennis2brains2b.nl	Fixed problem with adding null values through add parameter
 * 07-04-2005		dennis@brains2b.nl	FIX: for using CHAR fields in database
 * 16-08-2006	    dennis@brains2b.nl	fix on getPreparedStatement replacement
 * 09-02-2007       dennis@brains2b.nl  fix for select in where clause
 */
package org.brains2b.sql.oracle;
import org.brains2b.data.Condition;
import org.brains2b.data.sql.SqlCondition;

/** Oracle Condition is a specific implementation of Condition
 *  for Oracle databases.
 *
 * @author <A HREF="MAILTO:dennis@brains2b.nl">dennis@brains2b.nl</A>
 * @version 0.23.3 [09-02-2007]
 * @see Condition
 * @deprecated use SqlCondition instead 
 */
public class OracleCondition extends SqlCondition {

	/**
     * Default Constructor
     */
    public OracleCondition() {
        super();
    }

    /**
     * Constructor for OracleCondition
     */
    public OracleCondition(String orderBy) {
        super(orderBy);
    }

    /**
     * Constructor for OracleCondition
     */
    public OracleCondition(String field, Object value) {
        super(field, value);
    }

    /**
     * Constructor for OracleCondition
     */
    public OracleCondition(String field, Object value, String orderBy) {
        super(field, value, orderBy);
    }

}
