package org.brains2b.data.sql.lob;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;

import org.brains2b.data.HashCodeHelper;
import org.brains2b.sql.meta.types.Stream;

/**
 * Implementation of Stream for database streams that are connected
 * to the stream in the database
 *
 * @author <A HREF="MAILTO:dennis@brains2b.nl">dennis@brains2b.nl</A>
 * @version 0.90 [21-03-2008]
 */
public class ConnectedStream implements Stream {

	private LobCache m_cache;
	private InputStream m_is;
	public ConnectedStream() {
		super();
		m_cache = new LobCache();
	}
	
	public ConnectedStream(InputStream is) {
		super();	
		m_is = is;
	}
	
	public InputStream getInputStream() throws SQLException {
		if (m_cache != null) return m_cache.getBinaryStream();
		
		if (m_cache==null) {
			m_cache = new LobCache();
		}
		final OutputStream os = m_cache.setBinaryStream(0);
		
		return new InputStream() {
			public int read() throws IOException {
				int b = m_is.read();
				os.write(b);		
				return b;
			}
			
			public void close() throws IOException {
				os.close();
			}
		};
	}

	public OutputStream getOutputStream() throws SQLException {
		if (m_cache==null) {
			m_cache = new LobCache();
		}
		return m_cache.setBinaryStream(0);
	}

	public boolean isAccessed() throws SQLException {
		return m_cache!=null && m_cache.length()>0L;
	}
	
	public int hashCode() {
		return m_cache!=null?m_cache.hashCode():HashCodeHelper.INITIAL;
	}
}
