/* 	OracleDataHelper.java
 * 
 * Created on: 20-01-2002
 * Created by: Dennis Groenendijk
 * 
 * Copyright (c) 2003,2008 Brains2B.org
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that
 * the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions and 
 * the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
 * the following disclaimer in the documentation and/or other materials provided with the distribution. 
 * 3. The name of the author may not be used to endorse or promote products derived from this software 
 * without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/* @#History
 * [When]		[Who]				[What]
 * 16-01-2008	dennis@brains2b.nl	Renamed OracleDataHelper into SqlDataHelper,Waldorf changes			
 */
package org.brains2b.data.sql;

/** Class with static functions to help with SQL datatypes
 *  <p>Oracle has no support for boolean types and those are usually implemented
 *  as <code>VARCHAR2(1)</code> containing either <code>Y</code> or <code>N</code>.
 *  two functions <code>getYesNo(boolean)</code> and <code>getBoolean(String)</code> are implemented to 
 *  make that conversion
 *
 * @author <A HREF="MAILTO:dennis@brains2b.nl">dennis@brains2b.nl</A>
 * @version 0.11 [16-01-2008]
 */
public class SqlDataHelper {
	
    /**
     * Function getYesNo returns the character 'Y' for boolean true
     * and 'N' for boolean false
     * @param b boolean value,
     * @return String of length one containing either 'Y' or 'N'
     */
	public final static String getYesNo(boolean b) {
		return b?"Y":"N";
	}
	
    /**
     * Function getBoolean, returns true if the String consist of the
     * letter Y or y and return false in all other cases. Whitespace is ignored
     * in the evaluation.
     * @param yesNo String, that needs to be evaluated to true or false
     * @return boolean, true if String consist of 'Y' or 'y' and false in all other cases
     * @throws NullPointerException if String is null
     */
	public final static boolean getBoolean(String yesNo) {
		return yesNo.trim().equalsIgnoreCase("Y");
	}
}

