/* 	SqlDC.java
 * 
 * Created on: 20-01-2002
 * Created by: Dennis Groenendijk
 * 
 * Copyright (c) 2002-2008, Brains2B.org
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that
 * the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions and 
 * the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
 * the following disclaimer in the documentation and/or other materials provided with the distribution. 
 * 3. The name of the author may not be used to endorse or promote products derived from this software 
 * without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.brains2b.data.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.brains2b.data.DataControl;

/** Abstract class for SqlDataControl objects.
 *  <p>Implements the Object to hold, the Connection and the PreparedStatement to use
 *  but propagates all methods of the DataControl interface for concrete implementation
 *  <p>Adds an additional protected abstract method <code>getObject(ResultSet)</code> as a standardized
 *  method to create a data Object from a given ResultSet  
 *
 * @author <A HREF="MAILTO:dennis@brains2b.nl">dennis@brains2b.nl</A>
 * @version 0.11 [22-01-2008]
 * @see org.brains2b.data.DataControl
 */
public abstract class SqlDC implements DataControl {

	protected Object m_obj;
	protected Connection m_con;
	protected PreparedStatement m_prep;
	
    /**
     * Constructor for OracleDC which sets the Connection
     * to use for this DataControl and the Object on which it should
     * operate.
     * @param con Connection, the JDBC connection to use
     * @param o Object, the Object for which this DataControl exists.
     */
	public SqlDC(Connection con, Object o) {
		super();
		m_con=con;
		m_obj=o;
	}

    /**
     * Method getObject returns an instance of the Object this
     * DataControl was intended to service by reading out the resultset
     * and filling the methods of the object with the values of the individual fields
     * <p>This function needs to be implemented to match the specific class definition
     * of the return Object.
     * @param rs ResultSet, Actually a specific position in the ResultSet representing
     * a <b>row</b> in the table to be mapped to an instance of the Object
     * @return Object, an instance of the Object with all it's particular members filled
     * from the ResultSet row given through the parameter.
     * @throws Exception, if a SqlException occures.
     */
	protected abstract Object getObject(ResultSet rs) throws SQLException;
}
