/* 	OptimisticLock.java
 * 
 * Created on: 31-mrt-03
 * Created by: Dennis Groenendijk
 * 
 * Copyright (c) 2003-2007, Brains2B.org
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that
 * the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions and 
 * the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
 * the following disclaimer in the documentation and/or other materials provided with the distribution. 
 * 3. The name of the author may not be used to endorse or promote products derived from this software 
 * without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/*
 * @#History 
 * [When]       [Who]               [What] 
 * 28-11-2006   dennis@brains2b.nl  Added serialID as hashCode for empty objects
 * 12-02-2007   dennis@brains2b.nl  serialID() should be used as function
 */
package org.brains2b.data;

/** Interface that defines the methods used for 
 * 	optimistic locking.
 * <p>Classes that use this interface should define
 * a valid hashcode and a mutable member in which the 
 * hashcode can be set to a checksum.
 * <p><i>Note:</i>When calculating a hashcode for a dataobject
 * that uses a <code>ROWID</code>as primary key, be sure never to include
 * the <code>ROWID</code> in het hascode calculation.
 *
 * @author <A HREF="MAILTO:dennis@brains2b.nl">dennis@brains2b.nl</A>
 * @version 0.10.2 [12-02-2007]
 */
public interface OptimisticLock {

   
    /**
     * get the checksum value
     * @return int, the checksum value
     */
	public int getChecksum();
	
    public int serialID();
    /**
     * set the checksum value. Usually just a newly calculated
     * hashCode()
     * @param value int, the new checksum value
     */
	public void setChecksum(int value);
	
    /**
     * get a hash for the particular object that implements
     * this interface.
     * <p>Here to remind you: You cannot rely on <code>Object.hashCode()</code>
     * to implement a meaningfull OptimisticLock
     * @return int
     * @see Object#hashCode()
     */
	public int hashCode();

}
