/* 	HashCodeHelper.java
 *	Copyright (c) 2006, Brains2B.org
 *	
 *	Created by: Dennis Groenendijk
 *	Created on: Jun 8, 2006
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that  * the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions and 
 * the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
 * the following disclaimer in the documentation and/or other materials provided with the distribution. 
 * 3. The name of the author may not be used to endorse or promote products derived from this software 
 * without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.brains2b.data;

/**
 *  Best practice implementation for generating a hash code with a minimal amount of clashes,
 *  but a reasonable execution time
 *
 * @author <A HREF="MAILTO:dennis@brains2b.nl">dennis@brains2b.nl</A>
 * @version 0.10 [08-06-2006]
 */
public class HashCodeHelper {

	public final static int INITIAL=13;
	
	private final static int PRIME=37;
	
	public final static int hash(int h, int i) {
		return h*PRIME+i;
	}
	
	public final static int hash(int h, boolean b) {
		return h*PRIME+(b?1:0);
	}
	
	public final static int hash(int h, long l) {
		return h*PRIME+(int) (l^l>>>32);
	}
	
	public final static int hash(int h, double d) {
		return hash(h, Double.doubleToLongBits(d));
	}
	
	public final static int hash(int h, float f) {
		return hash(h, Float.floatToIntBits(f));
	}
	
	public final static int hash(int h, Object o) {
		
		return h*PRIME+(o==null?0:o.hashCode());
	}
}
