/* 	DataException.java
 *	Copyright (c) 2004-2008, Brains2B.org
 *	
 *	Created by: Dennis Groenendijk
 *	Created on: Feb 16, 2004
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that  * the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions and 
 * the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
 * the following disclaimer in the documentation and/or other materials provided with the distribution. 
 * 3. The name of the author may not be used to endorse or promote products derived from this software 
 * without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/* @#History
 * [When]		[Who]				[What]
 * 16-01-2008	dennis@brains2b.nl	Waldorf changes
 * TODO Implement ResourceBundle for the non specific data store errors.			
 */
package org.brains2b.data;

/** Implementation of Exception for <bold>future</bold> use as default Exception
 * in <code>DataControl</code> and <code>DataController</code> as replacement for
 * the <code>java.lang.Exception</code> which is used in current versions.
 * <p>Will be able to define the non specific data store errors by refering to a number only and will support
 * multilanguage support in the future. The as CONSTANT defined error types will be added to. Therefor if you
 * are going to use this, avoid the Numbers 0-9999. 
 * <p><b>Interface is not subject to change</b>
 * @author <A HREF="MAILTO:dennis@brains2b.nl">dennis@brains2b.nl</A>
 * @version 0.20 [16-01-2008]
 */
public class DataException extends Exception {
	
	private final static String[] MESSAGES = new String[] {
		"",
		"Retrieving of objects failed",
		"Insert of object failed",
		"Update of object failed",
		"Delete of object failed",
		"Record has been changed by another user",
		"Cannot insert record with empty primary key"
	};
	
	public final static int RETRIEVE_FAILED=1;
	public final static int INSERT_FAILED=2;
	public final static int UPDATE_FAILED=3;
	public final static int DELETE_FAILED=4;
	public final static int RECORD_CHANGED=5;
	public final static int NO_PRIMARY_KEY=6;
	private int m_errorNo;
	
    /**
     * Constructor for DataException.
     */
    public DataException() {
        super();
    }

	/**
	 * Constructor
	 * @param errorNo int, the errorNo for this Exception. in future releases
	 * all numbers will be implemented as CONSTANT. Avoid using numbers between 0-9999 for your
	 * own error messages.
	 */
	public DataException(int errorNo) {
		super();
		m_errorNo=errorNo;	
	}

	/**
	 * Constructor
	 * @param errorNo int, the errorNo for this Exception. in future releases
	 * all numbers will be implemented as CONSTANT. Avoid using numbers between 0-9999 for your
	 * own error messages.
	 * @param cause {@link Throwable}
	 */
	public DataException(int errorNo, Throwable cause) {
		super(cause);
		m_errorNo=errorNo;	
	}
	
    /**
     * Constructor for DataException.
     * @param message String, the message for this Exception, for future multilanguage
     * support use only the DataException(int) constructor
     */
    public DataException(String message) {
        super(message);
    }
    
     /**
     * Constructor for DataException.
     * @param message String, the message for this Exception, for future multilanguage
     * support use only the DataException(int) constructor
     * @param cause {@link Throwable}
     */
    public DataException(String message, Throwable t) {
        super(message,t);
    }

    /**
     * get the error number for this Exception
     * @return int, the error number
     */
    public int getErrorNo() {
        return m_errorNo;
    }

	/**
	 * get the Message for this Exception.
	 * <p>In future releases Exceptions which where created with an error number
	 * will lookup the appropriate message through a ResourceBundle implementation.
     * @see java.lang.Throwable#getMessage()
     */
    public String getMessage() {
    	if (m_errorNo<1 || m_errorNo>=MESSAGES.length) {
        	return super.getMessage();
    	} 
    	return MESSAGES[m_errorNo];
    	
    }

}
