/* 	DataControl.java
 * 
 * Created on: 20-01-2002
 * Created by: Dennis Groenendijk
 * 
 * Copyright (c) 2002-2008, Brains2B.org
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that
 * the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions and 
 * the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
 * the following disclaimer in the documentation and/or other materials provided with the distribution. 
 * 3. The name of the author may not be used to endorse or promote products derived from this software 
 * without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/* @#History
 * [When]		[Who]				[What]
 * 16-01-2008	dennis@brains2b.nl	Waldorf changes			
 */
package org.brains2b.data;

import java.util.List;

/**
 * Interface DataControl
 * <p>Used to implement DataControl for Data objects
 * <p>Implementation has the specific information on how to write/read data with a data source
 * to a data store. The DataControl is used from a class which implements <code>DataController<code>
 * which takes the data object as parameter and has some mechanisme to find the DataControl implementation
 * belonging to the DataObject.
 * <p>You would not refer to a DataControl directly in you code. You would just get and set the data object
 * to the general <code>DataController</code> and leave it to the <code>DataController</code> to invoke the 
 * DataControl and handle the read/write of the data.
 * <p>This interface is defined in general terms because no assumptions should be made about the
 * type of datastore. The most simple implementation would be using a JDBC connection, but you
 * could also use it for XML or flat file datastorage 
 * <p>Classes which implement this interface can be generated by <i>Sql2Class</i> project
 * @author <A HREF="MAILTO:dennis@brains2b.nl">dennis@brains2b.nl</A>
 * @version 0.20 [16-01-2007]
 */
public interface DataControl {

	/**
	 * Update the data object on primary key.
	 * @return int, the number of records updated, should alwyas return one
	 * @throws DataException, exception thrown if the specific data store controls throw an Exception,
	 * such as a JDBC driver.
	 */
	public int update() throws DataException;
	
	/**
	 * insert a data object
	 * @return int, the number or records updated, should always return one
	 * @throws DataException, exception thrown if the specific data store controls throw an Exception,
	 * such as a JDBC driver.
	 */
	public int insert() throws DataException;
	
	/**
	 * Delete the data object from the datatore on primary key.
	 * @return int, the number or records deleted, should always return one
	 * @throws DataException, exception thrown if the specific data store controls throw an Exception,
	 * such as a JDBC driver.
	 */
	public int delete() throws DataException;
	
	/**
	 * retrieve a data object on the basis of the primary key contained in Object o
	 * <p>Keep in mind that a <code>retrieve</code> expects an instance of the
	 * Object you're retrieving and returning an Object you're retrieving which could only match
	 * on the primary key
	 * @return Object, the data object which is retrieved from the primary key.
	 * @throws DataException, exception thrown if the specific data store controls throw an Exception,
	 * such as a JDBC driver.
	 */
	public Object retrieve() throws DataException;
	
	/**
	 * retrieve all records meeting the values set in <code>Condition</code>. The order would
	 * be the same as defined by the order by clause in the <code>Condition</code>
	 * @param con Condition, the condition to be used to retrieve the collection of data objects
	 * @return Vector, a collection of data objects
	 * @throws DataException, exception thrown if the specific data store controls throw an Exception,
	 * such as a JDBC driver.
	 * @see Condition
	 */
	public List retrieveList(Condition con) throws DataException;
}