/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.util;

public final class StringHelper {
    private static final char[] LEFTQUOTE = new char[]{'\'', '\"', '{', '[', '('};
    private static final char[] RIGHTQUOTE = new char[]{'\'', '\"', '}', ']', ')'};

    protected StringHelper() {
    }

    public static String initCaps(String string, char c) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (i != 0 && cArray[i - 1] != c) continue;
            cArray[i] = Character.toUpperCase(cArray[i]);
        }
        return String.valueOf(cArray);
    }

    public static String stripper(String string, char c) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        string = string.trim();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == c) continue;
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public static int getNonBaseCharacter(String string) {
        return StringHelper.getNonBaseCharacter(string, 0);
    }

    public static int getNonBaseCharacter(String string, int n) {
        int n2 = string.length();
        for (int i = n; i < string.length(); ++i) {
            if (Character.isLetterOrDigit(string.charAt(i))) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    public static String baseOnly(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        string = string.toUpperCase();
        for (int i = 0; i < string.length(); ++i) {
            if (!(string.charAt(i) >= 'A' & string.charAt(i) <= 'Z') && !(string.charAt(i) >= '0' & string.charAt(i) <= '9')) continue;
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public static final String breakLine(String string, int n) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = 0;
        String string2 = System.getProperty("line.separator");
        int n3 = 0;
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if (c == string2.charAt(n3)) {
                if (n3 == string2.length() - 1) {
                    n3 = 0;
                    n2 = i;
                    continue;
                }
                ++n3;
                continue;
            }
            if (i - n2 <= n) continue;
            for (int j = 0; j < i - n2; ++j) {
                switch (stringBuffer.charAt(i - j)) {
                    case ' ': 
                    case '!': 
                    case ',': 
                    case '.': 
                    case ':': 
                    case ';': 
                    case '?': {
                        stringBuffer.insert(i - j + 1, string2);
                        n2 = i - j + 1;
                    }
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String leftPad(String string, String string2, int n) {
        if (string == null) {
            string = new String();
        }
        if (string2 == null) {
            throw new NullPointerException("filler cannot be null");
        }
        if (string.length() >= n) {
            return string.substring(string.length() - n);
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n - string.length(); i += string2.length()) {
            stringBuffer.insert(i, string2);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String rightPad(String string, String string2, int n) {
        if (string == null) {
            string = new String();
        }
        if (string2 == null) {
            throw new NullPointerException("filler cannot be null");
        }
        if (string.length() >= n) {
            return string.substring(0, n);
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(string);
        for (int i = 0; i < n - string.length(); ++i) {
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static int matchBracket(char c, String string) {
        int n = string.indexOf(c);
        if (n == -1) {
            return -1;
        }
        return StringHelper.matchBracket(n, string);
    }

    public static int matchBracket(int n, String string) {
        int n2;
        char c = '\u0000';
        char c2 = '\u0000';
        int n3 = -1;
        if (n == -1) {
            return n;
        }
        for (n2 = 0; n2 < LEFTQUOTE.length; ++n2) {
            if (string.charAt(n) != LEFTQUOTE[n2]) continue;
            c = LEFTQUOTE[n2];
            c2 = RIGHTQUOTE[n2];
            break;
        }
        if (c == '\u0000' || c2 == '\u0000') {
            return -1;
        }
        n2 = 0;
        for (int i = n + 1; i < string.length(); ++i) {
            if (string.charAt(i) == c) {
                if (c == c2) {
                    n3 = i;
                    break;
                }
                ++n2;
            }
            if (string.charAt(i) != c2) continue;
            if (n2 == 0) {
                n3 = i;
                break;
            }
            --n2;
        }
        return n3;
    }

    public static boolean isQuoteCharacter(char c) {
        return c == '\'' || c == '\"';
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }
}

