/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.util;

import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.brains2b.util.StringHelper;

public class DateHelper {
    private static final Calendar m_cal = Calendar.getInstance();
    private static final int THIS_YEAR = m_cal.get(1);
    private static final Locale m_locale = Locale.getDefault();
    private static final String DEFAULT_DATE = "dd-MMM-yyyy";
    private static final String ISO_DATE = "yyyy-MM-dd";
    private static final String ISO_COMPLETE = "yyyy-MM-dd'T'HH:mm:ss.S";
    private static final SimpleDateFormat m_sdf = new SimpleDateFormat();

    public static final String fromDate(Date date) {
        if (date == null) {
            return null;
        }
        m_sdf.applyPattern(DEFAULT_DATE);
        return m_sdf.format(date);
    }

    public static final Date toDate(String string) throws NumberFormatException {
        return DateHelper.toDate(string, m_locale);
    }

    public static final Date toDate(String string, Locale locale) throws NumberFormatException {
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        boolean bl = false;
        if (string.length() == 6 && StringHelper.baseOnly(string).length() == 6 || string.length() == 8 && StringHelper.baseOnly(string).length() == 8) {
            if (m_locale.equals(Locale.US)) {
                n2 = Integer.parseInt(string.substring(0, 2)) - 1;
                n = Integer.parseInt(string.substring(2, 4));
            } else {
                n = Integer.parseInt(string.substring(0, 2));
                n2 = Integer.parseInt(string.substring(2, 4)) - 1;
            }
            bl = string.length() - 4 == 4;
            n3 = Integer.parseInt(string.substring(4));
        } else {
            int n4 = 0;
            for (int i = 0; i < string.length(); ++i) {
                if (Character.isLetterOrDigit(string.charAt(i)) || "fr".equals(locale.getLanguage()) && string.charAt(i) == '.') continue;
                if (n4 == 0) {
                    n = Integer.parseInt(string.substring(n4, i));
                    n4 = i + 1;
                    continue;
                }
                n2 = DateHelper.getMonth(string.substring(n4, i), locale);
                n4 = i + 1;
            }
            bl = string.length() - n4 == 4;
            n3 = Integer.parseInt(string.substring(n4));
        }
        if (n > 0 & n2 >= 0 & n3 > 0) {
            try {
                if (n3 < 100 && !bl) {
                    n3 += THIS_YEAR / 100 * 100;
                }
                m_cal.setLenient(false);
                m_cal.set(n3, n2, n, 0, 0, 0);
                m_cal.set(14, 0);
                return m_cal.getTime();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        throw new NumberFormatException("Not a valid date");
    }

    public static final String isoFromDate(Date date, boolean bl) {
        m_sdf.applyPattern(bl ? ISO_COMPLETE : ISO_DATE);
        String string = m_sdf.format(date);
        return string;
    }

    public static final String isoFromDate(Date date) {
        return DateHelper.isoFromDate(date, false);
    }

    public static final Date isoToDate(String string) {
        if (string == null) {
            return null;
        }
        try {
            int n = string.indexOf(84);
            boolean bl = n > 0 && string.charAt(n + 3) == ':';
            m_sdf.applyPattern(bl ? ISO_COMPLETE : ISO_DATE);
            return m_sdf.parse(string);
        }
        catch (ParseException parseException) {
            throw new NumberFormatException("Not a valid date");
        }
    }

    private static int getMonth(String string, Locale locale) {
        int n = 0;
        try {
            n = Integer.parseInt(string) - 1;
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
            if (string.length() > 3 && !"fr".equals(locale.getLanguage()) || "fr".equals(locale.getLanguage()) && !string.endsWith(".")) {
                String[] stringArray = dateFormatSymbols.getMonths();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!string.equalsIgnoreCase(stringArray[i])) continue;
                    return i;
                }
            } else {
                String[] stringArray = dateFormatSymbols.getShortMonths();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!string.equalsIgnoreCase(stringArray[i])) continue;
                    return i;
                }
            }
            return -1;
        }
    }
}

