/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.log;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class Logger
extends java.util.logging.Logger {
    public static final int PANIC = 0;
    public static final int INFO = 1;
    public static final int ERROR = 2;
    public static final int WARNING = 4;
    public static final int TRACE = 8;
    public static final int DEBUG = 16;
    public static final int DEBUG_VERBOSE = 32;
    private static Logger m_instance;

    protected Logger(String string, String string2) {
        super(string, string2);
        this.setLevel(Level.INFO);
        this.findFile();
        this.findSystemProperties();
    }

    protected static Logger instance() {
        if (m_instance == null) {
            m_instance = new Logger("twelbox", null);
        }
        return m_instance;
    }

    public static Logger getLogger() {
        return Logger.instance();
    }

    public static void setLevel(int n) {
        Logger.instance().setLevel(Logger.instance().getLevel(n));
    }

    public static void println(String string) {
        Logger.instance().log(Level.INFO, string);
    }

    public static void println(String string, int n) {
        Level level = Logger.instance().getLevel(n);
        Logger.instance().log(level, string);
    }

    public static void printException(String string, Exception exception) {
        if (Logger.instance().isLoggable(Level.CONFIG)) {
            Logger.instance().log(Level.SEVERE, string, exception);
        } else {
            Logger.instance().log(Level.SEVERE, string);
        }
    }

    public static void printException(Exception exception) {
        Logger.printException(exception.getMessage(), exception);
    }

    private void init(Properties properties) {
        StreamHandler streamHandler;
        String string = properties.getProperty("logger.level");
        int n = 1;
        if (string != null) {
            if ("TRACE".equalsIgnoreCase(string)) {
                n = 8;
            }
            if ("DEBUG".equalsIgnoreCase(string)) {
                n = 16;
            }
            if ("DEBUG_VERBOSE".equalsIgnoreCase(string)) {
                n = 32;
            }
            if ("WARNING".equalsIgnoreCase(string)) {
                n = 4;
            }
            if ("ERROR".equalsIgnoreCase(string)) {
                n = 2;
            }
        }
        this.setLevel(this.getLevel(n));
        string = properties.getProperty("logger.err.out");
        if (string != null) {
            try {
                streamHandler = new FileHandler(string, true);
                streamHandler.setLevel(Level.SEVERE);
                streamHandler.setFormatter(new ClassicFormatter());
                this.addHandler(streamHandler);
            }
            catch (IOException iOException) {
                string = null;
            }
        }
        if (string == null) {
            streamHandler = new ConsoleHandler();
            streamHandler.setLevel(Level.SEVERE);
            streamHandler.setFormatter(new ClassicFormatter());
            this.addHandler(streamHandler);
        }
        if ((string = properties.getProperty("logger.std.out")) != null) {
            try {
                streamHandler = new FileHandler(string, true);
                streamHandler.setFormatter(new ClassicFormatter());
                streamHandler.setLevel(Level.FINEST);
                streamHandler.setFilter(new Filter(){

                    public boolean isLoggable(LogRecord logRecord) {
                        return logRecord.getLevel() != Level.SEVERE;
                    }
                });
                this.addHandler(streamHandler);
            }
            catch (IOException iOException) {
                string = null;
            }
        }
        if (string == null) {
            streamHandler = new StreamHandler(System.out, new ClassicFormatter()){

                public synchronized void publish(LogRecord logRecord) {
                    super.publish(logRecord);
                    this.flush();
                }
            };
            streamHandler.setLevel(Level.FINEST);
            streamHandler.setFilter(new Filter(){

                public boolean isLoggable(LogRecord logRecord) {
                    return logRecord.getLevel() != Level.SEVERE;
                }
            });
            this.addHandler(streamHandler);
        }
    }

    private void findFile() {
        try {
            File file = new File("logger.properties");
            if (!file.exists()) {
                file = new File("conf/logger.properties");
            }
            if (file.exists()) {
                Properties properties = new Properties();
                properties.load(new FileInputStream(file));
                this.init(properties);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void findSystemProperties() {
        this.init(System.getProperties());
    }

    private final Level getLevel(int n) {
        switch (n) {
            case 0: 
            case 2: {
                return Level.SEVERE;
            }
            case 4: {
                return Level.WARNING;
            }
            case 8: {
                return Level.CONFIG;
            }
            case 16: {
                return Level.FINE;
            }
            case 32: {
                return Level.FINEST;
            }
        }
        return Level.INFO;
    }

    public static class ClassicFormatter
    extends Formatter {
        public String format(LogRecord logRecord) {
            String string = "";
            if (logRecord.getLevel() == Level.SEVERE) {
                string = "[  error  ] ";
            } else if (logRecord.getLevel() == Level.WARNING) {
                string = "[ warning ] ";
            }
            if (logRecord.getThrown() == null) {
                return string + logRecord.getMessage() + "\n";
            }
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.println(string + logRecord.getMessage());
            printWriter.println("********************* [Stack Trace] ******************");
            logRecord.getThrown().printStackTrace(printWriter);
            printWriter.println("********************* [End Trace] ******************");
            printWriter.flush();
            return stringWriter.toString();
        }
    }
}

