/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.collection;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.brains2b.collection.MapEntry;

public class SortedMap
implements Map,
Comparator,
Serializable {
    public static final int KEY = 0;
    public static final int VALUE = 1;
    public static final int NO_SORT = -1;
    private ArrayList m_content = new ArrayList();
    private int m_sortOrder = 0;
    private transient Collection m_values = null;
    private transient Set m_keys = null;

    public SortedMap(int n) {
        this.m_sortOrder = n;
    }

    public SortedMap() {
        this(-1);
    }

    public SortedMap(Map map, int n) {
        this(n);
        this.putAll(map);
    }

    public SortedMap(Map map) {
        this(map, -1);
    }

    public SortedMap(Hashtable hashtable) {
        this(hashtable, 0);
    }

    public int getSortOrder() {
        return this.m_sortOrder;
    }

    public void setSortOrder(int n) {
        if (n != 0 && n != 1 && n != -1) {
            throw new IllegalArgumentException("sortOrder must be either KEY|VALUE|NO_SORT");
        }
        this.m_sortOrder = n;
    }

    public int compare(Object object, Object object2) {
        if (this.m_sortOrder == -1) {
            return 1;
        }
        int n = -1;
        if (object instanceof Map.Entry && object2 instanceof Map.Entry) {
            String string;
            String string2;
            if (this.m_sortOrder == 0) {
                string2 = ((Map.Entry)object).getKey().toString();
                string = ((Map.Entry)object2).getKey().toString();
            } else {
                string2 = ((Map.Entry)object).getValue().toString();
                if (string2.compareTo(string = ((Map.Entry)object2).getValue().toString()) == 0) {
                    string2 = ((Map.Entry)object).getKey().toString();
                    string = ((Map.Entry)object2).getKey().toString();
                }
            }
            n = string2.compareTo(string);
        }
        if (!(object instanceof Map.Entry) || object == null) {
            n = 1;
        }
        return n;
    }

    public Set entrySet() {
        TreeSet treeSet = new TreeSet(this);
        treeSet.addAll(this.m_content);
        return treeSet;
    }

    public Object get(Object object) {
        Object object2 = null;
        if (object == null) {
            return null;
        }
        Iterator iterator = this.m_content.iterator();
        while (iterator.hasNext()) {
            MapEntry mapEntry = (MapEntry)iterator.next();
            if (!object.equals(mapEntry.getKey())) continue;
            object2 = mapEntry.getValue();
        }
        return object2;
    }

    public Object put(Object object, Object object2) {
        if (object2 == null || object == null) {
            return null;
        }
        Object object3 = null;
        MapEntry mapEntry = new MapEntry(object, object2);
        int n = this.m_content.indexOf(mapEntry);
        if (n == -1) {
            this.m_content.add(mapEntry);
        } else {
            object3 = ((MapEntry)this.m_content.get(n)).getValue();
            ((MapEntry)this.m_content.get(n)).setValue(object2);
        }
        return object3;
    }

    public void putAll(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            this.put(k, map.get(k));
        }
    }

    public Object remove(Object object) {
        MapEntry mapEntry = new MapEntry(object, object);
        Object object2 = null;
        int n = this.m_content.indexOf(mapEntry);
        if (n != -1) {
            object2 = ((MapEntry)this.m_content.get(n)).getValue();
            this.m_content.remove(mapEntry);
        }
        return object2;
    }

    public void clear() {
        this.m_content.clear();
    }

    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            return false;
        }
        Iterator iterator = this.m_content.iterator();
        while (iterator.hasNext()) {
            MapEntry mapEntry = (MapEntry)iterator.next();
            if (!object.equals(mapEntry.getValue())) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.m_content.isEmpty();
    }

    public Set keySet() {
        if (this.m_keys == null) {
            this.m_keys = new AbstractSet(){

                public Iterator iterator() {
                    return new Iterator(this){
                        private Iterator i;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                            this.i = 1.access$000(this.this$1).entrySet().iterator();
                        }

                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        public Object next() {
                            return ((Map.Entry)this.i.next()).getKey();
                        }

                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                public int size() {
                    return SortedMap.this.size();
                }

                public boolean contains(Object object) {
                    return SortedMap.this.containsKey(object);
                }

                static /* synthetic */ SortedMap access$000(1 var0) {
                    return var0.SortedMap.this;
                }
            };
        }
        return this.m_keys;
    }

    public int size() {
        return this.m_content.size();
    }

    public Collection values() {
        if (this.m_values == null) {
            this.m_values = new AbstractCollection(){

                public Iterator iterator() {
                    return new Iterator(this){
                        private Iterator i;
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                            this.i = 3.access$100(this.this$1).entrySet().iterator();
                        }

                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        public Object next() {
                            return ((Map.Entry)this.i.next()).getValue();
                        }

                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                public int size() {
                    return SortedMap.this.m_content.size();
                }

                public boolean contains(Object object) {
                    return SortedMap.this.containsValue(object);
                }

                static /* synthetic */ SortedMap access$100(3 var0) {
                    return var0.SortedMap.this;
                }
            };
        }
        return this.m_values;
    }
}

