/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.sql.meta;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.brains2b.log.Logger;
import org.brains2b.sql.SQLRecord;
import org.brains2b.sql.meta.ColumnModel;
import org.brains2b.sql.meta.ConstraintModel;
import org.brains2b.sql.meta.IndexModel;
import org.brains2b.sql.meta.ParameterModel;
import org.brains2b.sql.meta.ProcedureModel;
import org.brains2b.sql.meta.TableModel;
import org.brains2b.sql.meta.TypesInfo;

public class SQLMetaData {
    private DatabaseMetaData m_dbMeta;
    private Connection m_con;
    private String[] m_types;
    private PreparedStatement m_prep;
    private TypesInfo m_sqlTypes;

    public SQLMetaData() {
    }

    public SQLMetaData(Connection connection) {
        this.m_con = connection;
        this.m_dbMeta = null;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.m_dbMeta == null) {
            this.m_dbMeta = this.m_con.getMetaData();
        }
        return this.m_dbMeta;
    }

    public List getCatalogs() throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ResultSet resultSet = this.getMetaData().getCatalogs();
        while (resultSet.next()) {
            arrayList.add(resultSet.getString("TABLE_CAT"));
        }
        resultSet.close();
        return arrayList;
    }

    public List getSchemas() throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ResultSet resultSet = this.getMetaData().getSchemas();
        while (resultSet.next()) {
            arrayList.add(resultSet.getString("TABLE_SCHEM"));
        }
        resultSet.close();
        return arrayList;
    }

    public List getTableTypes() throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ResultSet resultSet = this.getMetaData().getTableTypes();
        while (resultSet.next()) {
            arrayList.add(resultSet.getString("TABLE_TYPE"));
        }
        arrayList.remove("SYNONYM");
        resultSet.close();
        return arrayList;
    }

    private String[] getTypes() throws SQLException {
        if (this.m_types == null) {
            List list = this.getTableTypes();
            this.m_types = new String[list.size()];
            list.toArray(this.m_types);
        }
        return this.m_types;
    }

    public List getTablesWithColumns(String string, String string2, String string3) throws SQLException {
        List list = this.getTables(string, string2, string3);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TableModel tableModel = (TableModel)iterator.next();
            tableModel.setColumns(this.getColumns(tableModel.getCatalog(), tableModel.getSchema(), tableModel.getName(), null));
        }
        return list;
    }

    public List getTables(String string, String string2, String string3) throws SQLException {
        return this.getTables(string, string2, string3, null);
    }

    public List getTables(String string, String string2, String string3, String string4) throws SQLException {
        String[] stringArray = null;
        stringArray = string4 == null ? this.getTypes() : new String[]{string4};
        ArrayList<TableModel> arrayList = new ArrayList<TableModel>();
        ResultSet resultSet = this.getMetaData().getTables(string, string2, string3, stringArray);
        while (resultSet.next()) {
            TableModel tableModel = new TableModel(SQLRecord.createRecord(resultSet));
            arrayList.add(tableModel);
        }
        resultSet.close();
        return arrayList;
    }

    public void setColumns(TableModel tableModel) throws SQLException {
        List list = this.getColumns(tableModel.getCatalog(), tableModel.getSchema(), tableModel.getName(), null);
        tableModel.setColumns(list);
    }

    public List getColumns(String string, String string2, String string3, String string4) throws SQLException {
        ArrayList<ColumnModel> arrayList = new ArrayList<ColumnModel>();
        ResultSet resultSet = this.getMetaData().getColumns(string, string2, string3, string4);
        while (resultSet.next()) {
            ColumnModel columnModel = new ColumnModel(SQLRecord.createRecord(resultSet));
            if (columnModel.getDataType() == 91 && this.isOracleDriver()) {
                columnModel.getRecord().setValue("DATA_TYPE", (Object)new Integer(93));
            }
            arrayList.add(columnModel);
        }
        resultSet.close();
        return arrayList;
    }

    public void setPrimaryKey(TableModel tableModel) throws SQLException {
        this.setPrimaryKey(tableModel, false);
    }

    public void setPrimaryKey(TableModel tableModel, boolean bl) throws SQLException {
        try {
            Object object;
            if (!bl) {
                object = this.getConstraints(tableModel.getCatalog(), tableModel.getSchema(), tableModel.getName(), "PRIMARY KEY");
                if (object.isEmpty() && !tableModel.getType().equals("VIEW")) {
                    this.setPseudoKeys(tableModel);
                    if (tableModel.getPrimaryKey() == null) {
                        Logger.println((String)("TABLE " + tableModel.getName() + " Primary Keys are defined as pseudo"), (int)16);
                    }
                } else if (!object.isEmpty()) {
                    tableModel.setPrimaryKey((ConstraintModel)object.get(0));
                }
            }
            if (bl || tableModel.getPrimaryKey() == null && !tableModel.getType().equals("VIEW")) {
                object = new SQLRecord(9);
                ((SQLRecord)object).setColumn(0, "TYPE", String.class, "COLUMN");
                ((SQLRecord)object).setColumn(1, "ORDINAL_POSITION", Integer.class, new Integer(1));
                ((SQLRecord)object).setColumn(2, "COLUMN_NAME", String.class, "ROWID");
                ((SQLRecord)object).setColumn(3, "TABLE_NAME", String.class, tableModel.getName());
                ((SQLRecord)object).setColumn(4, "DATA_TYPE", Integer.class, new Integer(1111));
                ((SQLRecord)object).setColumn(5, "TYPE_NAME", String.class, "ROWID");
                ((SQLRecord)object).setColumn(6, "TABLE_CAT", String.class, tableModel.getCatalog());
                ColumnModel columnModel = new ColumnModel((SQLRecord)object);
                tableModel.getColumns().add(columnModel);
                object = new SQLRecord(2);
                ((SQLRecord)object).setColumn(0, "NAME", String.class, "ROWID");
                ((SQLRecord)object).setColumn(1, "TABLE_NAME", String.class, tableModel.getName());
                ConstraintModel constraintModel = new ConstraintModel("PRIMARY KEY", (SQLRecord)object);
                SQLRecord sQLRecord = (SQLRecord)columnModel.getRecord().clone();
                sQLRecord.setValue("ORDINAL_POSITION", (Object)new Integer(1));
                constraintModel.addColumn(new ColumnModel(sQLRecord));
                tableModel.setPrimaryKey(constraintModel);
                Logger.println((String)("TABLE " + tableModel.getName() + " has NO primary key, ROWID used"), (int)16);
            }
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == 0) {
                Logger.println((String)"JDBC Driver does not support primary keys", (int)4);
            }
            throw sQLException;
        }
    }

    private void setPseudoKeys(TableModel tableModel) throws SQLException {
        List list = this.getIndices(tableModel.getCatalog(), tableModel.getSchema(), tableModel.getName(), true);
        if (list != null) {
            Object object;
            Iterator iterator = list.iterator();
            Object object2 = null;
            while (iterator.hasNext()) {
                object = (IndexModel)iterator.next();
                if (!((IndexModel)object).isUnique() || object2 != null && ((IndexModel)object2).getColumns().size() <= ((IndexModel)object).getColumns().size()) continue;
                object2 = object;
            }
            if (object2 == null) {
                return;
            }
            object = new SQLRecord(2);
            ((SQLRecord)object).setColumn(0, "NAME", String.class, "ROWID");
            ((SQLRecord)object).setColumn(1, "TABLE_NAME", String.class, tableModel.getName());
            ConstraintModel constraintModel = new ConstraintModel("PRIMARY KEY", (SQLRecord)object);
            for (int i = 0; i < tableModel.getColumns().size(); ++i) {
                ColumnModel columnModel = (ColumnModel)tableModel.getColumns().get(i);
                for (int j = 0; j < ((IndexModel)object2).getColumns().size(); ++j) {
                    if (!((ColumnModel)((IndexModel)object2).getColumns().get(j)).getName().equals(columnModel.getName())) continue;
                    constraintModel.addColumn(columnModel);
                }
            }
            tableModel.setPrimaryKey(constraintModel);
        }
    }

    public void setIndices(TableModel tableModel, boolean bl) throws SQLException {
        List list = this.getIndices(tableModel.getCatalog(), tableModel.getSchema(), tableModel.getName(), bl);
        tableModel.setIndices(list);
    }

    public List getIndices(String string, String string2, String string3, boolean bl) throws SQLException {
        HashMap<String, IndexModel> hashMap = new HashMap<String, IndexModel>();
        ResultSet resultSet = null;
        resultSet = this.isOracleDriver() ? this.getOracleIndexes(string2, string3, bl) : this.getMetaData().getIndexInfo(string, string2, string3, bl, true);
        while (resultSet.next()) {
            SQLRecord sQLRecord = SQLRecord.createRecord(resultSet);
            IndexModel indexModel = new IndexModel(this.createSubSet(sQLRecord, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME"}));
            ColumnModel columnModel = new ColumnModel(this.createSubSet(sQLRecord, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC"}));
            String string4 = indexModel.getName();
            if (string4 == null) continue;
            IndexModel indexModel2 = (IndexModel)hashMap.get(string4);
            if (indexModel2 == null) {
                indexModel2 = new IndexModel(sQLRecord);
                hashMap.put(string4, indexModel2);
            }
            indexModel2.setColumn(columnModel.getSequence(), columnModel);
        }
        resultSet.close();
        if (this.isOracleDriver() && this.m_prep != null) {
            this.m_prep.close();
        }
        return new ArrayList(hashMap.values());
    }

    public List getProcedures(String string, String string2, String string3) throws SQLException {
        return this.getProcedures(string, string2, string3, true);
    }

    public List getProcedures(String string, String string2, String string3, boolean bl) throws SQLException {
        ArrayList<ProcedureModel> arrayList = new ArrayList<ProcedureModel>();
        ResultSet resultSet = this.getMetaData().getProcedures(string, string2, string3);
        while (resultSet.next()) {
            ProcedureModel procedureModel = new ProcedureModel(SQLRecord.createRecord(resultSet));
            if (bl) {
                this.setParameters(procedureModel);
            }
            arrayList.add(procedureModel);
        }
        resultSet.close();
        return arrayList;
    }

    public void setParameters(ProcedureModel procedureModel) throws SQLException {
        List list = this.getParameters(procedureModel.getCatalog(), procedureModel.getSchema(), procedureModel.getName());
        if (procedureModel.getType() == "FUNCTION") {
            procedureModel.setReturnValue((ParameterModel)list.get(0));
            list.remove(0);
        }
        procedureModel.setParameters(list);
    }

    public List getParameters(String string, String string2, String string3) throws SQLException {
        ArrayList<ParameterModel> arrayList = new ArrayList<ParameterModel>();
        ResultSet resultSet = this.getMetaData().getProcedureColumns(string == null ? "" : string, string2, string3, null);
        while (resultSet.next()) {
            ParameterModel parameterModel = new ParameterModel(SQLRecord.createRecord(resultSet));
            arrayList.add(parameterModel);
        }
        resultSet.close();
        return arrayList;
    }

    public Connection getConnection() {
        return this.m_con;
    }

    public void setConnection(Connection connection) {
        this.m_con = connection;
        this.m_dbMeta = null;
    }

    public List getConstraints(String string, String string2, String string3, String string4) throws SQLException {
        ColumnModel columnModel;
        String string5;
        ResultSet resultSet;
        String string6 = null;
        ArrayList<ConstraintModel> arrayList = new ArrayList<ConstraintModel>();
        ConstraintModel constraintModel = null;
        SQLRecord sQLRecord = null;
        if (string4 == null || string4 == "PRIMARY KEY") {
            resultSet = this.getMetaData().getPrimaryKeys(string, string2, string3);
            while (resultSet.next()) {
                sQLRecord = SQLRecord.createRecord(resultSet);
                string5 = resultSet.getString("PK_NAME");
                if (string5 == null && string6 == null || !string5.equals(string6)) {
                    constraintModel = new ConstraintModel("PRIMARY KEY", this.createSubSet(sQLRecord, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "PK_NAME"}, "PK"));
                    arrayList.add(constraintModel);
                }
                columnModel = new ColumnModel(this.createSubSet(sQLRecord, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "KEY_SEQ"}));
                this.renameColumn(columnModel.getRecord(), "KEY_SEQ", "ORDINAL_POSITION");
                constraintModel.addColumn(columnModel);
                string6 = string5;
            }
        }
        constraintModel = null;
        sQLRecord = null;
        string6 = null;
        if (string4 == null || string4 == "FOREIGN KEY") {
            resultSet = this.getMetaData().getImportedKeys(string, string2, string3);
            while (resultSet.next()) {
                sQLRecord = SQLRecord.createRecord(resultSet);
                string5 = resultSet.getString("FK_NAME");
                if (string5 == null && string6 == null || !string5.equals(string6)) {
                    constraintModel = new ConstraintModel("FOREIGN KEY", this.createSubSet(sQLRecord, new String[]{"FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FK_NAME", "UPDATE_RULE", "DELETE_RULE", "DEFERRABILITY"}, "FK"));
                    arrayList.add(constraintModel);
                }
                columnModel = new ColumnModel(this.createSubSet(sQLRecord, new String[]{"FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ"}, "FK"));
                this.renameColumn(columnModel.getRecord(), "KEY_SEQ", "ORDINAL_POSITION");
                constraintModel.addColumn(columnModel);
                columnModel = new ColumnModel(this.createSubSet(sQLRecord, new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "KEY_SEQ"}, "PK"));
                this.renameColumn(columnModel.getRecord(), "KEY_SEQ", "ORDINAL_POSITION");
                constraintModel.addColumn(columnModel);
                string6 = string5;
            }
        }
        return arrayList;
    }

    private SQLRecord createSubSet(SQLRecord sQLRecord, String[] stringArray) throws SQLException {
        return this.createSubSet(sQLRecord, stringArray, null);
    }

    private SQLRecord createSubSet(SQLRecord sQLRecord, String[] stringArray, String string) throws SQLException {
        SQLRecord sQLRecord2 = new SQLRecord(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            int n = sQLRecord.getIndex(stringArray[i]);
            if (string != null && stringArray[i].startsWith(string)) {
                int n2 = string.length();
                if (stringArray[i].charAt(n2) == '_') {
                    ++n2;
                }
                stringArray[i] = stringArray[i].substring(n2);
            }
            if (n == -1) continue;
            sQLRecord2.setColumn(i, stringArray[i], sQLRecord.getColumnType(n), sQLRecord.getValue(n));
        }
        return sQLRecord2;
    }

    private void renameColumn(SQLRecord sQLRecord, String string, String string2) {
        int n = sQLRecord.getIndex(string);
        if (n != -1) {
            sQLRecord.setColumn(n, string2);
        }
    }

    private boolean isOracleDriver() throws SQLException {
        return "Oracle".equals(this.getMetaData().getDatabaseProductName());
    }

    private ResultSet getOracleIndexes(String string, String string2, boolean bl) throws SQLException {
        this.m_prep = this.getMetaData().getConnection().prepareStatement("SELECT NULL TABLE_CAT, I.TABLE_OWNER TABLE_SCHEM,I.TABLE_NAME, I.INDEX_NAME, INDEX_TYPE INDEX_QUALIFIER,COLUMN_NAME, DECODE(UNIQUENESS,'UNIQUE',0,1) NON_UNIQUE, COLUMN_POSITION ORDINAL_POSITION, DESCEND ASC_OR_DESC FROM ALL_INDEXES I, ALL_IND_COLUMNS C  WHERE I.TABLE_OWNER LIKE ? AND I.TABLE_NAME LIKE ? AND I.INDEX_NAME = C.INDEX_NAME AND I.OWNER = C.INDEX_OWNER AND  ((UNIQUENESS='UNIQUE' AND 1=?) OR (0=?)) ORDER BY TABLE_CAT, TABLE_SCHEM, I.TABLE_NAME,ORDINAL_POSITION");
        this.m_prep.setString(1, string == null ? "%" : string);
        this.m_prep.setString(2, string2);
        this.m_prep.setInt(3, bl ? 1 : 0);
        this.m_prep.setInt(4, bl ? 1 : 0);
        ResultSet resultSet = this.m_prep.executeQuery();
        return resultSet;
    }

    public TypesInfo getTypeInfo() {
        if (this.m_sqlTypes == null) {
            try {
                this.m_sqlTypes = new TypesInfo(this.m_con);
                this.getMetaData();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.m_sqlTypes;
    }
}

