/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.loader;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class DynamicClassLoader {
    public static final Class loadClass(String string, URL[] uRLArray) throws ClassNotFoundException {
        if (uRLArray == null) {
            return Class.forName(string);
        }
        URLClassLoader uRLClassLoader = URLClassLoader.newInstance(uRLArray);
        Class<?> clazz = uRLClassLoader.loadClass(string);
        if (clazz == null) {
            throw new ClassNotFoundException(string + " cannot be found.");
        }
        return clazz;
    }

    public static final Class[] loadClasses(URL[] uRLArray) throws ClassNotFoundException {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < uRLArray.length; ++i) {
            File file = new File(uRLArray[i].getPath());
            if (file.isDirectory()) {
                arrayList.addAll(DynamicClassLoader.loadDir(file, file));
                continue;
            }
            arrayList.addAll(DynamicClassLoader.loadArchive(file));
        }
        Class[] classArray = new Class[arrayList.size()];
        arrayList.toArray(classArray);
        return classArray;
    }

    public static final Class[] findImplementation(Class clazz, URL[] uRLArray) throws ClassNotFoundException {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        Class[] classArray = DynamicClassLoader.loadClasses(uRLArray);
        for (int i = 0; i < classArray.length; ++i) {
            if (!clazz.isAssignableFrom(classArray[i])) continue;
            arrayList.add(classArray[i]);
        }
        Class[] classArray2 = new Class[arrayList.size()];
        arrayList.toArray(classArray2);
        return classArray2;
    }

    private static final ArrayList loadDir(File file, File file2) throws ClassNotFoundException {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        File[] fileArray = file2.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    arrayList.addAll(DynamicClassLoader.loadDir(file, fileArray[i]));
                    continue;
                }
                if (!fileArray[i].isFile() || !fileArray[i].getName().endsWith(".class")) continue;
                String string = fileArray[i].getAbsolutePath().substring(file.getAbsolutePath().length() + 1);
                string = string.substring(0, string.length() - 6);
                string = string.replace('/', '.');
                try {
                    arrayList.add(DynamicClassLoader.loadClass(string, new URL[]{fileArray[i].toURL()}));
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return arrayList;
    }

    private static final ArrayList loadArchive(File file) throws ClassNotFoundException {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (!zipEntry.getName().endsWith(".class")) continue;
                String string = zipEntry.getName();
                string = string.substring(0, string.length() - 6);
                string = string.replace('/', '.');
                try {
                    arrayList.add(DynamicClassLoader.loadClass(string, new URL[]{file.toURL()}));
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        catch (ZipException zipException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return arrayList;
    }
}

