/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.attest.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class AttestView
extends JFrame
implements ActionListener,
MouseMotionListener,
MouseListener {
    private JTextPane m_textPane;
    private HashMap m_children;
    private File m_path;
    private Manifest m_manifest;
    private Stack m_last;
    private JButton m_back;

    public AttestView() {
        this.init();
        this.m_last = new Stack();
    }

    private void init() {
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.setTitle("@test 0.10.1");
        Dimension d = this.getToolkit().getScreenSize();
        d.height = d.height * 30 / 100;
        d.width = d.width * 30 / 100;
        this.setLocation(MouseInfo.getPointerInfo().getLocation());
        this.setSize(d);
        JPanel main = new JPanel(new BorderLayout());
        this.setContentPane(main);
        main.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_textPane = new JTextPane();
        this.m_textPane.setEditable(false);
        this.m_textPane.addMouseMotionListener(this);
        this.m_textPane.addMouseListener(this);
        main.add((Component)new JScrollPane(this.m_textPane), "Center");
        StyledDocument doc = this.m_textPane.getStyledDocument();
        Style dflt = StyleContext.getDefaultStyleContext().getStyle("default");
        Style notfound = doc.addStyle("notfound", dflt);
        StyleConstants.setForeground(notfound, Color.red);
        StyleConstants.setStrikeThrough(notfound, true);
        Style link = doc.addStyle("link", doc.getStyle("default"));
        StyleConstants.setForeground(link, Color.blue);
        StyleConstants.setUnderline(link, true);
        this.m_back = new JButton("<<");
        this.m_back.setActionCommand("Back");
        this.m_back.addActionListener(this);
        this.m_back.setVisible(false);
        JButton b = new JButton("Ok");
        b.setActionCommand("Close");
        b.addActionListener(this);
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        p.add((Component)this.m_back, "West");
        p.add((Component)b, "East");
        main.add((Component)p, "South");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setManifest(Manifest mf, File path) {
        this.m_children = new HashMap();
        this.m_manifest = mf;
        this.m_path = path;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        String text = null;
        try {
            mf.write(baos);
            baos.flush();
            text = new String(baos.toByteArray(), "ISO8859_1");
            text = text.replaceAll("\r\n ", "");
            this.m_textPane.setText(text);
        }
        catch (Exception ex) {
            this.showException(ex);
            return;
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException iex) {}
        }
        StyledDocument doc = this.m_textPane.getStyledDocument();
        doc.setCharacterAttributes(0, doc.getLength(), doc.getStyle("default"), true);
        this.m_textPane.setCaretPosition(0);
        try {
            String as = (String)mf.getMainAttributes().get(Attributes.Name.CLASS_PATH);
            if (as != null) {
                int cidx = text.indexOf("Class-Path");
                StringTokenizer st = new StringTokenizer(as);
                while (st.hasMoreTokens()) {
                    String jarName = st.nextToken();
                    File fj = new File(path, jarName);
                    int idx = text.indexOf(jarName, cidx) - 1;
                    if (fj.exists()) {
                        JarFile jar = new JarFile(fj);
                        Manifest jMf = jar.getManifest();
                        jar.close();
                        if (jMf == null) continue;
                        doc.setCharacterAttributes(idx, jarName.length(), doc.getStyle("link"), false);
                        this.m_children.put(jarName, jMf);
                        continue;
                    }
                    doc.setCharacterAttributes(idx, jarName.length(), doc.getStyle("notfound"), false);
                }
            }
        }
        catch (Exception blex) {
            this.showException(blex);
            return;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if ("Close".equals(e.getActionCommand())) {
            this.dispose();
        } else if ("Back".equals(e.getActionCommand())) {
            this.setManifest((Manifest)this.m_last.pop(), this.m_path);
            if (this.m_last.isEmpty()) {
                this.m_back.setVisible(false);
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
        int pos = this.m_textPane.viewToModel(e.getPoint());
        Element el = this.m_textPane.getStyledDocument().getCharacterElement(pos);
        if (el.getAttributes().containsAttribute(SimpleAttributeSet.NameAttribute, "link")) {
            this.m_textPane.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.m_textPane.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void mouseClicked(MouseEvent e) {
        int pos = this.m_textPane.viewToModel(e.getPoint());
        Element el = this.m_textPane.getStyledDocument().getCharacterElement(pos);
        if (el.getAttributes().containsAttribute(SimpleAttributeSet.NameAttribute, "link")) {
            try {
                String s = this.m_textPane.getStyledDocument().getText(el.getStartOffset(), el.getEndOffset() - el.getStartOffset());
                Manifest mf = (Manifest)this.m_children.get(s);
                if (mf != null) {
                    this.m_last.push(this.m_manifest);
                    this.m_back.setVisible(true);
                    this.setManifest(mf, this.m_path);
                }
            }
            catch (BadLocationException blex) {
                this.showException(blex);
            }
        }
    }

    private void showException(Exception ex) {
        JOptionPane.showMessageDialog(this, ex.getMessage(), "@test:error", 0);
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

