/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.attest;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.JOptionPane;
import org.brains2b.attest.OsStub;
import org.brains2b.attest.gui.AttestView;
import org.brains2b.console.ArgumentException;
import org.brains2b.console.ArgumentMap;
import org.brains2b.console.Main;
import org.brains2b.log.Logger;

public class Attest
extends Main {
    public Attest() {
        this.init();
    }

    public static void main(String[] args) {
        Attest attest = new Attest();
        Logger.println(System.getProperty("os.name"), 16);
        if ("Mac OS X".equals(System.getProperty("os.name"))) {
            try {
                OsStub macOsx = (OsStub)Class.forName("org.brains2b.attest.macosx.MacOsXHandler").newInstance();
                while (macOsx.getFilename() == null) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (Exception exception) {}
                }
                attest.setArgument("jar", macOsx.getFilename());
            }
            catch (Exception ex) {
                attest.showException(ex);
            }
        } else {
            attest.makeArgumentList(args);
        }
        attest.doIt();
    }

    private void doIt() {
        try {
            File f = new File(this.getArgument("jar"));
            JarFile jar = new JarFile(f);
            Manifest mf = jar.getManifest();
            if (mf == null) {
                throw new FileNotFoundException("No manifest in: " + jar.getName());
            }
            if (GraphicsEnvironment.isHeadless() || "true".equals(this.getArgument("console"))) {
                mf.write(System.out);
                System.exit(0);
            }
            AttestView view = new AttestView();
            view.setManifest(mf, f.getParentFile());
            view.setVisible(true);
        }
        catch (IOException iex) {
            this.showException(iex);
            Logger.printException(iex);
        }
    }

    private void init() {
        ArgumentMap map = new ArgumentMap();
        map.addArgument("jar", true);
        map.addOption("console", 'c', false);
        this.setArgumentMap(map);
    }

    protected void handleException(ArgumentException ex) {
        if (GraphicsEnvironment.isHeadless() || "true".equals(this.getArgument("console"))) {
            super.handleException(ex);
        } else {
            this.showException(ex);
            System.exit(1);
        }
    }

    private void showException(Exception ex) {
        if (GraphicsEnvironment.isHeadless() || "true".equals(this.getArgument("console"))) {
            return;
        }
        JOptionPane.showMessageDialog(null, ex.getMessage(), "@test:error", 0);
    }
}

