/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.util;

public final class StringHelper {
    private static final char[] LEFTQUOTE = new char[]{'\'', '\"', '{', '[', '('};
    private static final char[] RIGHTQUOTE = new char[]{'\'', '\"', '}', ']', ')'};

    protected StringHelper() {
    }

    public static String initCaps(String str, char c) {
        if (str == null) {
            return null;
        }
        char[] chr = str.toCharArray();
        int i = 0;
        while (i < chr.length) {
            if (i == 0 || chr[i - 1] == c) {
                chr[i] = Character.toUpperCase(chr[i]);
            }
            ++i;
        }
        return String.valueOf(chr);
    }

    public static String stripper(String str, char c) {
        if (str == null) {
            return null;
        }
        StringBuffer stb = new StringBuffer();
        str = str.trim();
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) != c) {
                stb.append(str.charAt(i));
            }
            ++i;
        }
        return stb.toString();
    }

    public static int getNonBaseCharacter(String value) {
        return StringHelper.getNonBaseCharacter(value, 0);
    }

    public static int getNonBaseCharacter(String value, int start) {
        int idx = value.length();
        int i = start;
        while (i < value.length()) {
            if (!Character.isLetterOrDigit(value.charAt(i))) {
                idx = i;
                break;
            }
            ++i;
        }
        return idx;
    }

    public static String baseOnly(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer stb = new StringBuffer();
        str = str.toUpperCase();
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) >= 'A' & str.charAt(i) <= 'Z' || str.charAt(i) >= '0' & str.charAt(i) <= '9') {
                stb.append(str.charAt(i));
            }
            ++i;
        }
        return stb.toString();
    }

    public static final String breakLine(String str, int maxLen) {
        if (str == null) {
            return null;
        }
        StringBuffer stb = new StringBuffer(str);
        int last = 0;
        char linebreak = System.getProperty("line.separator").charAt(0);
        int i = 0;
        while (i < stb.length()) {
            char ch = stb.charAt(i);
            if (ch == linebreak) {
                last = i;
            } else if (i - last > maxLen) {
                int j = 0;
                while (j < i - last) {
                    switch (stb.charAt(i - j)) {
                        case ' ': 
                        case '!': 
                        case ',': 
                        case '.': 
                        case ':': 
                        case ';': 
                        case '?': {
                            stb.insert(i - j + 1, linebreak);
                            last = i - j + 1;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return stb.toString();
    }

    public static String leftPad(String str, String filler, int len) {
        if (str == null) {
            str = new String();
        }
        if (filler == null) {
            throw new NullPointerException("filler cannot be null");
        }
        if (str.length() >= len) {
            return str.substring(str.length() - len);
        }
        StringBuffer stb = new StringBuffer(len);
        int i = 0;
        while (i < len - str.length()) {
            stb.insert(i, filler);
            i += filler.length();
        }
        stb.append(str);
        return stb.toString();
    }

    public static String rightPad(String str, String filler, int len) {
        if (str == null) {
            str = new String();
        }
        if (filler == null) {
            throw new NullPointerException("filler cannot be null");
        }
        if (str.length() >= len) {
            return str.substring(0, len);
        }
        StringBuffer stb = new StringBuffer(len);
        stb.append(str);
        int i = 0;
        while (i < len - str.length()) {
            stb.append(filler);
            ++i;
        }
        return stb.toString();
    }

    public static int matchBracket(char left, String line) {
        int idx = line.indexOf(left);
        if (idx == -1) {
            return -1;
        }
        return StringHelper.matchBracket(idx, line);
    }

    public static int matchBracket(int pos, String line) {
        char begin = '\u0000';
        char end = '\u0000';
        int out = -1;
        if (pos == -1) {
            return pos;
        }
        int i = 0;
        while (i < LEFTQUOTE.length) {
            if (line.charAt(pos) == LEFTQUOTE[i]) {
                begin = LEFTQUOTE[i];
                end = RIGHTQUOTE[i];
                break;
            }
            ++i;
        }
        if (begin == '\u0000' || end == '\u0000') {
            return -1;
        }
        int cnt = 0;
        int i2 = pos + 1;
        while (i2 < line.length()) {
            if (line.charAt(i2) == begin) {
                if (begin == end) {
                    out = i2;
                    break;
                }
                ++cnt;
            }
            if (line.charAt(i2) == end) {
                if (cnt == 0) {
                    out = i2;
                    break;
                }
                --cnt;
            }
            ++i2;
        }
        return out;
    }

    public static boolean isQuoteCharacter(char a) {
        return a == '\'' || a == '\"';
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }
}

