/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.util;

import java.util.Locale;

public class LocaleHelper {
    public static final Locale getLocale(String localeAbbr) {
        if (localeAbbr != null) {
            if (localeAbbr.equalsIgnoreCase("default")) {
                return new Locale("", "");
            }
            int idx = localeAbbr.indexOf("_");
            if (idx != -1) {
                String lang = localeAbbr.substring(0, idx).toLowerCase();
                String cntry = localeAbbr.substring(idx + 1).toUpperCase();
                if (LocaleHelper.isLanguage(lang) && LocaleHelper.isCountry(cntry)) {
                    return new Locale(lang, cntry);
                }
            } else {
                String lang = localeAbbr.toLowerCase();
                if (LocaleHelper.isLanguage(lang)) {
                    return new Locale(lang, "");
                }
            }
        }
        return null;
    }

    public static final boolean isLanguage(String isoLang) {
        return LocaleHelper.inList(isoLang, Locale.getISOLanguages());
    }

    public static final boolean isCountry(String isoLang) {
        return LocaleHelper.inList(isoLang, Locale.getISOCountries());
    }

    private static final boolean inList(Object item, Object[] list) {
        if (item != null && list != null) {
            int i = 0;
            while (i < list.length) {
                if (item.equals(list[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

