/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.util;

public class HexHelper {
    private static final char[] CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static final String encode(byte[] b) {
        if (b == null) {
            throw new NullPointerException("no bytes to digest");
        }
        char[] chars = new char[b.length * 2];
        int i = 0;
        while (i < b.length) {
            chars[i * 2] = CHARS[(0xF0 & b[i]) / 16];
            chars[i * 2 + 1] = CHARS[(0xF & b[i]) % 16];
            ++i;
        }
        return new String(chars);
    }

    public static final byte[] decode(String s) {
        if (s == null) {
            throw new NullPointerException("no String to digest");
        }
        if (s.startsWith("0x")) {
            s = s.substring(2);
        }
        if (s.length() % 2 != 0) {
            s = "0" + s;
        }
        char[] c = s.toCharArray();
        byte[] b = new byte[s.length() / 2];
        int i = 0;
        while (i < b.length) {
            b[i] = (byte)(Character.digit(c[i * 2], 16) * 16 + Character.digit(c[i * 2 + 1], 16));
            ++i;
        }
        return b;
    }
}

