/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.brains2b.util.StringHelper;

public class GuiHelper {
    public static Rectangle setMiddle(Rectangle target, Rectangle source) {
        target.x = (int)source.getCenterX() - target.width / 2;
        target.y = (int)source.getCenterY() - target.height / 2;
        return target;
    }

    public static Rectangle setMiddle(Rectangle target, Dimension source) {
        return GuiHelper.setMiddle(target, new Rectangle(source));
    }

    public static final Dimension decodeDimension(String dim) {
        if (StringHelper.isEmpty(dim)) {
            return null;
        }
        Dimension d = new Dimension();
        try {
            int idx = dim.indexOf(44);
            if (idx == -1) {
                d.width = Integer.parseInt(dim);
                d.height = Integer.parseInt(dim);
            } else {
                d.width = Integer.parseInt(dim.substring(0, idx));
                d.height = Integer.parseInt(dim.substring(idx + 1));
            }
        }
        catch (NumberFormatException nfex) {
            d = null;
        }
        return d;
    }

    public static final String encodeDimension(Dimension d) {
        if (d == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(d.width).append(',').append(d.height);
        return sb.toString();
    }

    public static int getWidth(String str) {
        JLabel jl = new JLabel();
        str = String.valueOf(str) + "M";
        int w = SwingUtilities.computeStringWidth(jl.getFontMetrics(jl.getFont()), str);
        return w;
    }

    public static int getWidth(String str, int width) {
        int w = GuiHelper.getWidth(str);
        return w > width ? w : width;
    }

    public static boolean isColor(String value) {
        try {
            Color c = Color.decode(value);
            if (c != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isFont(String value) {
        try {
            Font f = Font.decode(value);
            if (f != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

