/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.task;

import java.util.ArrayList;
import java.util.Stack;
import org.brains2b.task.Task;
import org.brains2b.task.TaskEvent;
import org.brains2b.task.TaskListener;

public abstract class DefaultTask
implements Task {
    private boolean m_finished = false;
    private int m_result = 0;
    private Stack m_messages;
    private ArrayList m_eventList = new ArrayList();
    private int m_max;
    private int m_min;
    private int m_pos;

    public boolean isFinished() {
        return this.m_finished;
    }

    public void setFinished(boolean b) {
        boolean old = this.m_finished;
        this.m_finished = b;
        if (old != b) {
            TaskEvent e = new TaskEvent(this, 1);
            e.setFinished(b);
            this.fireTaskEvent(e);
        }
    }

    public int getResult() {
        return this.m_result;
    }

    protected void setResult(int result) {
        this.m_result = result;
    }

    public Stack getMessages() {
        return this.m_messages;
    }

    protected void addMessage(String s) {
        if (this.m_messages == null) {
            this.m_messages = new Stack();
        }
        this.m_messages.add(s);
    }

    protected void addException(Throwable t) {
        if (this.m_messages == null) {
            this.m_messages = new Stack();
        }
        this.m_messages.add(t);
    }

    public int getMax() {
        return this.m_max;
    }

    public int getMin() {
        return this.m_min;
    }

    public int getPosition() {
        return this.m_pos;
    }

    public void addTaskListener(TaskListener listener) {
        this.m_eventList.add(listener);
    }

    public void removeTaskListener(TaskListener listener) {
        this.m_eventList.remove(listener);
    }

    protected void progress() {
        this.progress(++this.m_pos);
    }

    protected void progress(int value) {
        if (!this.isFinished()) {
            this.m_pos = value;
            if (this.m_pos > this.m_max) {
                this.m_pos = this.m_max;
            }
            TaskEvent e = new TaskEvent(this, 0);
            e.setMax(this.m_max);
            e.setMin(this.m_min);
            e.setPosition(this.m_pos);
            e.setFinished(this.m_finished);
            this.fireTaskEvent(e);
        }
    }

    protected void fireTaskEvent(TaskEvent e) {
        int i = 0;
        while (i < this.m_eventList.size()) {
            ((TaskListener)this.m_eventList.get(i)).taskProgressed(e);
            ++i;
        }
    }

    protected void setMax(int max) {
        this.m_max = max;
    }

    protected void setMin(int min) {
        this.m_min = min;
    }
}

