/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.log;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import org.brains2b.log.Logger;

public class Timer
extends Logger {
    private static Timer m_timer;
    private SimpleDateFormat m_sdf = new SimpleDateFormat("yyyy-mm-dd HH:mm:ss");
    protected Hashtable m_timers = new Hashtable();

    protected Timer() {
    }

    protected static Timer timer() {
        if (m_timer == null) {
            m_timer = new Timer();
        }
        return m_timer;
    }

    public static void printTime() {
        if (Timer.getLevel() == 16) {
            Timer.println(Timer.timer().m_sdf.format(new Date()), 16);
        }
    }

    public static void start(String timerid) {
        if (Timer.getLevel() == 16) {
            Timer.timer().m_timers.put(timerid, new Date());
        }
    }

    public static void end(String timerid, String message) {
        if (Timer.getLevel() == 16) {
            Date end = new Date();
            Date start = (Date)Timer.timer().m_timers.get(timerid);
            long diff = end.getTime() - start.getTime();
            Timer.println(String.valueOf(message) + ":" + Timer.timer().format(diff), 16);
        }
    }

    private final String format(long diff) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SS");
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTime(new Date(diff));
        return sdf.format(cal.getTime());
    }
}

