/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.log;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Properties;

public class Logger {
    public static final int PANIC = 0;
    public static final int INFO = 1;
    public static final int ERROR = 2;
    public static final int WARNING = 4;
    public static final int TRACE = 8;
    public static final int DEBUG = 16;
    public static final int DEBUG_VERBOSE = 32;
    private static Logger m_logger;
    public PrintWriter m_out = new PrintWriter(System.out, true);
    public PrintWriter m_err = new PrintWriter(System.err, true);
    private int m_level = 2;

    protected Logger() {
        this.findFile();
        this.findSystemProperties();
    }

    protected static Logger instance() {
        if (m_logger == null) {
            m_logger = new Logger();
        }
        return m_logger;
    }

    protected int getInternalLevel() {
        return this.m_level;
    }

    protected void setInternalLevel(int level) {
        this.m_level = level;
    }

    public static void setLevel(int level) {
        Logger.instance().setInternalLevel(level);
    }

    public static int getLevel() {
        return Logger.instance().getInternalLevel();
    }

    public static void println(String str) {
        Logger.instance().m_out.println(str);
    }

    public static void println(String str, int level) {
        if (level <= 1) {
            Logger.println(str);
        } else if (level <= Logger.instance().getInternalLevel()) {
            if (level != 2) {
                String type = "";
                if (level == 4) {
                    type = "[ warning ] ";
                }
                if (level == 0) {
                    type = "[  panic  ] ";
                }
                Logger.instance().m_out.println(String.valueOf(type) + str);
            } else {
                Logger.instance().m_err.println("[  error  ] " + str);
            }
        }
    }

    public static void printException(String message, Exception ex) {
        Logger.println(message, 2);
        if (Logger.getLevel() >= 8) {
            Logger.instance().m_err.println("********************* [Stack Trace] ******************");
            ex.printStackTrace(Logger.instance().m_err);
            Logger.instance().m_err.println("********************* [End Trace] ******************");
        }
    }

    public static void printException(Exception ex) {
        Logger.printException(ex.getMessage(), ex);
    }

    private void init(Properties prop) {
        String value = prop.getProperty("logger.level");
        if (value != null) {
            if ("TRACE".equalsIgnoreCase(value)) {
                this.m_level = 8;
            }
            if ("DEBUG".equalsIgnoreCase(value)) {
                this.m_level = 16;
            }
            if ("DEBUG_VERBOSE".equalsIgnoreCase(value)) {
                this.m_level = 32;
            }
            if ("WARNING".equalsIgnoreCase(value)) {
                this.m_level = 4;
            }
            if ("ERROR".equalsIgnoreCase(value)) {
                this.m_level = 2;
            }
        }
        if ((value = prop.getProperty("logger.err.out")) != null) {
            try {
                this.m_err = new PrintWriter(new PrintStream(new FileOutputStream(value)), true);
            }
            catch (IOException iex) {
                this.m_err = new PrintWriter(System.err, true);
            }
        }
        if ((value = prop.getProperty("logger.std.out")) != null) {
            try {
                this.m_out = new PrintWriter(new PrintStream(new FileOutputStream(value)), true);
            }
            catch (IOException iex) {
                this.m_out = new PrintWriter(System.out, true);
            }
        }
    }

    private void findFile() {
        try {
            File fl = new File("logger.properties");
            if (!fl.exists()) {
                fl = new File("conf/logger.properties");
            }
            if (fl.exists()) {
                Properties prop = new Properties();
                prop.load(new FileInputStream(fl));
                this.init(prop);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void findSystemProperties() {
        this.init(System.getProperties());
    }
}

