/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.console;

import java.util.Hashtable;
import java.util.Map;
import org.brains2b.console.ArgumentException;
import org.brains2b.console.ArgumentMap;

public class Main {
    private ArgumentMap m_argumentMap;
    private Map m_argumentList;

    protected ArgumentMap getArgumentMap() {
        return this.m_argumentMap;
    }

    protected void setArgumentMap(ArgumentMap argumentMap) {
        this.m_argumentMap = argumentMap;
    }

    public String getArgument(String name) {
        if (this.m_argumentList == null) {
            throw new NullPointerException("There are no arguments set");
        }
        return (String)this.m_argumentList.get(name);
    }

    public void setArgument(String name, String value) {
        if (this.m_argumentList == null) {
            this.m_argumentList = new Hashtable();
        }
        this.m_argumentList.put(name, value);
    }

    public void makeArgumentList(String[] args) {
        if (args == null) {
            return;
        }
        this.m_argumentList = new Hashtable();
        if (this.m_argumentMap == null) {
            int i = 0;
            while (i < args.length) {
                this.m_argumentList.put(String.valueOf(i), args[i]);
                ++i;
            }
        } else {
            try {
                this.m_argumentList = this.m_argumentMap.getList(args);
            }
            catch (ArgumentException ex) {
                this.handleException(ex);
            }
        }
    }

    protected void handleException(ArgumentException ex) {
        System.err.println(String.valueOf(ex.getArgument()) + ": " + ex.getMessage());
        System.exit(1);
    }
}

