/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.collection;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.brains2b.collection.MapEntry;

public class SortedMap
extends AbstractMap
implements Comparator,
Serializable {
    private ArrayList m_content = new ArrayList();
    public static final int KEY = 0;
    public static final int VALUE = 1;
    public static final int NO_SORT = -1;
    private int m_sortOrder = 0;

    public SortedMap() {
        this(-1);
    }

    public SortedMap(Map map, int sortOrder) {
        this(sortOrder);
        this.putAll(map);
    }

    public SortedMap(Map map) {
        this(-1);
        this.putAll(map);
    }

    public SortedMap(Hashtable ht) {
        this(0);
        this.putAll((Map)ht);
    }

    public SortedMap(int sortOrder) {
        this.m_sortOrder = sortOrder;
    }

    public int getSortOrder() {
        return this.m_sortOrder;
    }

    public void setSortOrder(int sortOrder) {
        this.m_sortOrder = sortOrder;
    }

    public int compare(Object oLeft, Object oRight) {
        if (this.m_sortOrder == -1) {
            return 1;
        }
        String left = null;
        String right = null;
        int result = -1;
        if (oLeft instanceof Map.Entry && oRight instanceof Map.Entry) {
            if (this.m_sortOrder == 0) {
                left = ((Map.Entry)oLeft).getKey().toString();
                right = ((Map.Entry)oRight).getKey().toString();
            } else {
                left = ((Map.Entry)oLeft).getValue().toString();
                if (left.compareTo(right = ((Map.Entry)oRight).getValue().toString()) == 0) {
                    left = ((Map.Entry)oLeft).getKey().toString();
                    right = ((Map.Entry)oRight).getKey().toString();
                }
            }
            result = left.compareTo(right);
        }
        return result;
    }

    public Set entrySet() {
        TreeSet ts = new TreeSet(this);
        ts.addAll(this.m_content);
        return ts;
    }

    public Object get(Object key) {
        Object result = null;
        if (key == null) {
            return null;
        }
        Iterator it = this.m_content.iterator();
        while (it.hasNext()) {
            MapEntry e = (MapEntry)it.next();
            if (!key.equals(e.getKey())) continue;
            result = e.getValue();
        }
        return result;
    }

    public Object put(Object key, Object value) {
        Object old = null;
        MapEntry se = new MapEntry(key, value);
        int idx = this.m_content.indexOf(se);
        if (idx == -1) {
            this.m_content.add(se);
        } else {
            old = ((MapEntry)this.m_content.get(idx)).getValue();
            ((MapEntry)this.m_content.get(idx)).setValue(value);
        }
        return old;
    }

    public void putAll(Map m) {
        Iterator it = m.keySet().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            this.put(o, m.get(o));
        }
    }

    public Object remove(Object key) {
        MapEntry se = new MapEntry(key, key);
        Object value = null;
        int idx = this.m_content.indexOf(se);
        if (idx != -1) {
            value = ((MapEntry)this.m_content.get(idx)).getValue();
            this.m_content.remove(se);
        }
        return value;
    }
}

